I will build the Interactive 3D Particle Christmas Tree application based on your requirements.

### Project Structure
I will create a folder `christmas-tree-interactive` containing a single self-contained `index.html` file (as requested for portability) that includes:
- **HTML Structure**: Container for the 3D canvas, video input (hidden), and UI overlay.
- **CSS**: Modern dark-themed styling for the UI panels.
- **JavaScript**: All logic for Three.js, MediaPipe, and interaction.

### Implementation Steps

1.  **Core 3D Setup (Three.js)**
    - Initialize Scene, PerspectiveCamera, and WebGLRenderer.
    - Implement a particle system using `THREE.BufferGeometry` to generate a spiral Christmas tree shape.
    - Add a secondary particle system for falling snow.
    - specific `UnrealBloomPass` for the "cinematic" glow effect.

2.  **Computer Vision (MediaPipe Hands)**
    - Integrate `@mediapipe/hands` and `@mediapipe/camera_utils`.
    - Set up real-time hand tracking from the webcam.
    - Implement gesture detection logic:
        - **Open Palm**: Trigger particle dispersion (explosion effect).
        - **Fist/Closed Hand**: Trigger particle cohesion (reform tree).
        - **Pinch**: (Optional foundation) Prepare logic for future photo interaction.

3.  **Interaction & Animation Loop**
    - Create a custom shader or update loop to animate particles.
    - smooth interpolation (lerp) between "Tree Shape" and "Exploded Shape" based on hand state.
    - Add mouse/touch controls as a fallback to hand gestures.

4.  **User Interface**
    - Add a control panel for:
        - Particle Color Picker.
        - Bloom/Glow Intensity.
        - Toggle for Camera/Gesture control.

5.  **Verification**
    - I will verify the code by checking for syntax errors and ensuring all CDNs are correct.
    - Since I cannot physically test the webcam, I will ensure the fallback mouse interactions work for testing the particle physics.
